C------------------------------------------------------------------------------
C Copyright 1996-2013 United States Government as represented by the
C Administrator of the National Aeronautics and Space Administration.
C All Rights Reserved.
C------------------------------------------------------------------------------
C------------------------------------------------------------------------------
C
C  NSSDC/CDF				Digital FORTRAN-specific include
C					file for FORTRAN interface.
C
C  Version 1.0, 20-Sep-99, Raytheon ITSS.
C
C  Modification history:
C
C   V1.0  20-Sep-99, M Liu      Original version.
C   V1.1  08-Apr-04, M Liu      Added  new data type CDF_EPOCH16 and some
C                               epoch functions related to the new type.
C   V1.2  08-Jul-11, M Liu      Added  new routines for TT2000 data type.
C
C------------------------------------------------------------------------------

       INTERFACE
         INTEGER*4 FUNCTION CDF_CONFIRM_ATTR_EXISTENCE
          !DEC$ ATTRIBUTES C, REFERENCE, VARYING :: CDF_CONFIRM_ATTR_EXISTENCE
          !DEC$ ALIAS CDF_CONFIRM_ATTR_EXISTENCE, '_cdf_confirm_attr_existence'
         END FUNCTION CDF_CONFIRM_ATTR_EXISTENCE
       END INTERFACE

       INTERFACE
         INTEGER*4 FUNCTION CDF_CONFIRM_ZVAR_EXISTENCE
          !DEC$ ATTRIBUTES C, REFERENCE, VARYING :: CDF_CONFIRM_ZVAR_EXISTENCE
          !DEC$ ALIAS CDF_CONFIRM_ZVAR_EXISTENCE, '_cdf_confirm_zvar_existence'
         END FUNCTION CDF_CONFIRM_ZVAR_EXISTENCE
       END INTERFACE

       INTERFACE
         INTEGER*4 FUNCTION CDF_CONFIRM_GENTRY_EXISTENCE
          !DEC$ ATTRIBUTES C, REFERENCE, VARYING :: CDF_CONFIRM_GENTRY_EXISTENCE
          !DEC$ ALIAS CDF_CONFIRM_GENTRY_EXISTENCE, '_cdf_confirm_gentry_existence'
         END FUNCTION CDF_CONFIRM_GENTRY_EXISTENCE
       END INTERFACE

       INTERFACE
         INTEGER*4 FUNCTION CDF_CONFIRM_RENTRY_EXISTENCE
          !DEC$ ATTRIBUTES C, REFERENCE, VARYING :: CDF_CONFIRM_RENTRY_EXISTENCE
          !DEC$ ALIAS CDF_CONFIRM_RENTRY_EXISTENCE, '_cdf_confirm_rentry_existence'
         END FUNCTION CDF_CONFIRM_RENTRY_EXISTENCE
       END INTERFACE

       INTERFACE
         INTEGER*4 FUNCTION CDF_CONFIRM_ZENTRY_EXISTENCE
          !DEC$ ATTRIBUTES C, REFERENCE, VARYING :: CDF_CONFIRM_ZENTRY_EXISTENCE
          !DEC$ ALIAS CDF_CONFIRM_ZENTRY_EXISTENCE, '_cdf_confirm_zentry_existence'
         END FUNCTION CDF_CONFIRM_ZENTRY_EXISTENCE
       END INTERFACE

       INTERFACE
         INTEGER*4 FUNCTION CDF_CONFIRM_ZVAR_PADVALUE_EXIST
          !DEC$ ATTRIBUTES C, REFERENCE, VARYING :: CDF_CONFIRM_ZVAR_PADVALUE_EXIST
          !DEC$ ALIAS CDF_CONFIRM_ZVAR_PADVALUE_EXIST,'_cdf_confirm_zvar_padvalue_exist'
         END FUNCTION CDF_CONFIRM_ZVAR_PADVALUE_EXIST
       END INTERFACE

       INTERFACE
         SUBROUTINE CDF_SET_DECODING
          !DEC$ ATTRIBUTES C, REFERENCE, VARYING ::CDF_SET_DECODING
          !DEC$ ALIAS CDF_SET_DECODING, '_cdf_set_decoding'
         END SUBROUTINE CDF_SET_DECODING
       END INTERFACE

       INTERFACE
         SUBROUTINE CDF_SET_READONLY_MODE
          !DEC$ ATTRIBUTES C, REFERENCE, VARYING ::CDF_SET_READONLY_MODE
          !DEC$ ALIAS CDF_SET_READONLY_MODE, '_cdf_set_readonly_mode'
         END SUBROUTINE CDF_SET_READONLY_MODE
       END INTERFACE

       INTERFACE
         SUBROUTINE CDF_SET_NEGTOPOSFP0_MODE
          !DEC$ ATTRIBUTES C, REFERENCE, VARYING ::CDF_SET_NEGTOPOSFP0_MODE
          !DEC$ ALIAS CDF_SET_NEGTOPOSFP0_MODE, '_cdf_set_negtoposfp0_mode'
         END SUBROUTINE CDF_SET_NEGTOPOSFP0_MODE
       END INTERFACE

       INTERFACE
         SUBROUTINE CDF_SET_COMPRESS_CACHESIZE
          !DEC$ ATTRIBUTES C, REFERENCE, VARYING ::CDF_SET_COMPRESS_CACHESIZE
          !DEC$ ALIAS CDF_SET_COMPRESS_CACHESIZE, '_cdf_set_compress_cachesize'
         END SUBROUTINE CDF_SET_COMPRESS_CACHESIZE
       END INTERFACE

       INTERFACE
         SUBROUTINE CDF_SET_STAGE_CACHESIZE
          !DEC$ ATTRIBUTES C, REFERENCE, VARYING ::CDF_SET_STAGE_CACHESIZE
          !DEC$ ALIAS CDF_SET_STAGE_CACHESIZE, '_cdf_set_stage_cachesize'
         END SUBROUTINE CDF_SET_STAGE_CACHESIZE
       END INTERFACE

       INTERFACE
         SUBROUTINE CDF_SET_ZVAR_CACHESIZE
          !DEC$ ATTRIBUTES C, REFERENCE, VARYING ::CDF_SET_ZVAR_CACHESIZE
          !DEC$ ALIAS CDF_SET_ZVAR_CACHESIZE, '_cdf_set_zvar_cachesize'
         END SUBROUTINE CDF_SET_ZVAR_CACHESIZE
       END INTERFACE

       INTERFACE
         SUBROUTINE CDF_SET_ZVARS_CACHESIZE
          !DEC$ ATTRIBUTES C, REFERENCE, VARYING ::CDF_SET_ZVARS_CACHESIZE
          !DEC$ ALIAS CDF_SET_ZVARS_CACHESIZE, '_cdf_set_zvars_cachesize'
         END SUBROUTINE CDF_SET_ZVARS_CACHESIZE
       END INTERFACE

       INTERFACE
         SUBROUTINE CDF_SET_ZVAR_SEQPOS
          !DEC$ ATTRIBUTES C, REFERENCE, VARYING ::CDF_SET_ZVAR_SEQPOS
          !DEC$ ALIAS CDF_SET_ZVAR_SEQPOS, '_cdf_set_zvar_seqpos'
         END SUBROUTINE CDF_SET_ZVAR_SEQPOS
       END INTERFACE

       INTERFACE
         SUBROUTINE CDF_SET_ZVAR_RESERVEPERCENT
          !DEC$ ATTRIBUTES C, REFERENCE, VARYING ::CDF_SET_ZVAR_RESERVEPERCENT
          !DEC$ ALIAS CDF_SET_ZVAR_RESERVEPERCENT, '_cdf_set_zvar_reservepercent'
         END SUBROUTINE CDF_SET_ZVAR_RESERVEPERCENT
       END INTERFACE

       INTERFACE
         SUBROUTINE CDF_SET_ZMODE
          !DEC$ ATTRIBUTES C, REFERENCE, VARYING ::CDF_SET_ZMODE
          !DEC$ ALIAS CDF_SET_ZMODE, '_cdf_set_zmode'
         END SUBROUTINE CDF_SET_ZMODE
       END INTERFACE

       INTERFACE
         SUBROUTINE CDF_SET_ATTR_SCOPE
          !DEC$ ATTRIBUTES C, REFERENCE, VARYING ::CDF_SET_ATTR_SCOPE
          !DEC$ ALIAS CDF_SET_ATTR_SCOPE, '_cdf_set_attr_scope'
         END SUBROUTINE CDF_SET_ATTR_SCOPE
       END INTERFACE

       INTERFACE
         SUBROUTINE CDF_SET_ATTR_GENTRY_DATASPEC
          !DEC$ ATTRIBUTES C, REFERENCE, VARYING ::CDF_SET_ATTR_GENTRY_DATASPEC
          !DEC$ ALIAS CDF_SET_ATTR_GENTRY_DATASPEC, '_cdf_set_attr_gentry_dataspec'
         END SUBROUTINE CDF_SET_ATTR_GENTRY_DATASPEC
       END INTERFACE

       INTERFACE
         SUBROUTINE CDF_SET_ATTR_RENTRY_DATASPEC
          !DEC$ ATTRIBUTES C, REFERENCE, VARYING ::CDF_SET_ATTR_RENTRY_DATASPEC
          !DEC$ ALIAS CDF_SET_ATTR_RENTRY_DATASPEC, '_cdf_set_attr_rentry_dataspec'
         END SUBROUTINE CDF_SET_ATTR_RENTRY_DATASPEC
       END INTERFACE

       INTERFACE
         SUBROUTINE CDF_SET_ATTR_ZENTRY_DATASPEC
          !DEC$ ATTRIBUTES C, REFERENCE, VARYING ::CDF_SET_ATTR_ZENTRY_DATASPEC
          !DEC$ ALIAS CDF_SET_ATTR_ZENTRY_DATASPEC, '_cdf_set_attr_zentry_dataspec'
         END SUBROUTINE CDF_SET_ATTR_ZENTRY_DATASPEC
       END INTERFACE

       INTERFACE
         SUBROUTINE CDF_SET_COMPRESSION
          !DEC$ ATTRIBUTES C, REFERENCE, VARYING ::CDF_SET_COMPRESSION
          !DEC$ ALIAS CDF_SET_COMPRESSION, '_cdf_set_compression'
         END SUBROUTINE CDF_SET_COMPRESSION
       END INTERFACE

       INTERFACE
         SUBROUTINE CDF_SET_ENCODING
          !DEC$ ATTRIBUTES C, REFERENCE, VARYING ::CDF_SET_ENCODING
          !DEC$ ALIAS CDF_SET_ENCODING, '_cdf_set_encoding'
         END SUBROUTINE CDF_SET_ENCODING
       END INTERFACE

       INTERFACE
         SUBROUTINE CDF_SET_FORMAT
          !DEC$ ATTRIBUTES C, REFERENCE, VARYING ::CDF_SET_FORMAT
          !DEC$ ALIAS CDF_SET_FORMAT, '_cdf_set_format'
         END SUBROUTINE CDF_SET_FORMAT
       END INTERFACE

       INTERFACE
         SUBROUTINE CDF_SET_MAJORITY
          !DEC$ ATTRIBUTES C, REFERENCE, VARYING ::CDF_SET_MAJORITY
          !DEC$ ALIAS CDF_SET_MAJORITY, '_cdf_set_majority'
         END SUBROUTINE CDF_SET_MAJORITY
       END INTERFACE

       INTERFACE
         SUBROUTINE CDF_SET_CACHESIZE
          !DEC$ ATTRIBUTES C, REFERENCE, VARYING ::CDF_SET_CACHESIZE
          !DEC$ ALIAS CDF_SET_CACHESIZE, '_cdf_set_cachesize'
         END SUBROUTINE CDF_SET_CACHESIZE
       END INTERFACE

       INTERFACE
         SUBROUTINE CDF_SET_ZVAR_DATASPEC
          !DEC$ ATTRIBUTES C, REFERENCE, VARYING ::CDF_SET_ZVAR_DATASPEC
          !DEC$ ALIAS CDF_SET_ZVAR_DATASPEC, '_cdf_set_zvar_dataspec'
         END SUBROUTINE CDF_SET_ZVAR_DATASPEC
       END INTERFACE

       INTERFACE
         SUBROUTINE CDF_SET_ZVAR_RECVARIANCE
          !DEC$ ATTRIBUTES C, REFERENCE, VARYING ::CDF_SET_ZVAR_RECVARIANCE
          !DEC$ ALIAS CDF_SET_ZVAR_RECVARIANCE, '_cdf_set_zvar_recvariance'
         END SUBROUTINE CDF_SET_ZVAR_RECVARIANCE
       END INTERFACE

       INTERFACE
         SUBROUTINE CDF_SET_ZVAR_DIMVARIANCES
          !DEC$ ATTRIBUTES C, REFERENCE, VARYING ::CDF_SET_ZVAR_DIMVARIANCES
          !DEC$ ALIAS CDF_SET_ZVAR_DIMVARIANCES, '_cdf_set_zvar_dimvariances'
         END SUBROUTINE CDF_SET_ZVAR_DIMVARIANCES
       END INTERFACE

       INTERFACE
         SUBROUTINE CDF_SET_ZVAR_BLOCKINGFACTOR
          !DEC$ ATTRIBUTES C, REFERENCE, VARYING ::CDF_SET_ZVAR_BLOCKINGFACTOR
          !DEC$ ALIAS CDF_SET_ZVAR_BLOCKINGFACTOR, '_cdf_set_zvar_blockingfactor'
         END SUBROUTINE CDF_SET_ZVAR_BLOCKINGFACTOR
       END INTERFACE

       INTERFACE
         SUBROUTINE CDF_SET_ZVAR_COMPRESSION
          !DEC$ ATTRIBUTES C, REFERENCE, VARYING ::CDF_SET_ZVAR_COMPRESSION
          !DEC$ ALIAS CDF_SET_ZVAR_COMPRESSION, '_cdf_set_zvar_compression'
         END SUBROUTINE CDF_SET_ZVAR_COMPRESSION
       END INTERFACE

       INTERFACE
         SUBROUTINE CDF_SET_ZVAR_PADVALUE
          !DEC$ ATTRIBUTES C, REFERENCE, VARYING ::CDF_SET_ZVAR_PADVALUE
          !DEC$ ALIAS CDF_SET_ZVAR_PADVALUE, '_cdf_set_zvar_padvalue'
         END SUBROUTINE CDF_SET_ZVAR_PADVALUE
       END INTERFACE

       INTERFACE
         SUBROUTINE CDF_SET_ZVAR_SPARSERECORDS
          !DEC$ ATTRIBUTES C, REFERENCE, VARYING ::CDF_SET_ZVAR_SPARSERECORDS
          !DEC$ ALIAS CDF_SET_ZVAR_SPARSERECORDS, '_cdf_set_zvar_sparserecords'
         END SUBROUTINE CDF_SET_ZVAR_SPARSERECORDS
       END INTERFACE

       INTERFACE
         SUBROUTINE CDF_SET_ZVAR_ALLOCRECS
          !DEC$ ATTRIBUTES C, REFERENCE, VARYING ::CDF_SET_ZVAR_ALLOCRECS
          !DEC$ ALIAS CDF_SET_ZVAR_ALLOCRECS, '_cdf_set_zvar_allocrecs'
         END SUBROUTINE CDF_SET_ZVAR_ALLOCRECS
       END INTERFACE

       INTERFACE
         SUBROUTINE CDF_SET_ZVAR_ALLOCBLOCKRECS
          !DEC$ ATTRIBUTES C, REFERENCE, VARYING ::CDF_SET_ZVAR_ALLOCBLOCKRECS
          !DEC$ ALIAS CDF_SET_ZVAR_ALLOCBLOCKRECS, '_cdf_set_zvar_allocblockrecs'
         END SUBROUTINE CDF_SET_ZVAR_ALLOCBLOCKRECS
       END INTERFACE

       INTERFACE
         SUBROUTINE CDF_SET_ZVAR_INITIALRECS
          !DEC$ ATTRIBUTES C, REFERENCE, VARYING ::CDF_SET_ZVAR_INITIALRECS
          !DEC$ ALIAS CDF_SET_ZVAR_INITIALRECS, '_cdf_set_zvar_initialrecs'
         END SUBROUTINE CDF_SET_ZVAR_INITIALRECS
       END INTERFACE

       INTERFACE
         SUBROUTINE CDF_PUT_ZVAR_SEQDATA
          !DEC$ ATTRIBUTES C, REFERENCE, VARYING ::CDF_PUT_ZVAR_SEQDATA
          !DEC$ ALIAS CDF_PUT_ZVAR_SEQDATA, '_cdf_put_zvar_seqdata'
         END SUBROUTINE CDF_PUT_ZVAR_SEQDATA
       END INTERFACE

       INTERFACE
         SUBROUTINE CDF_TT2000_TO_UTC_PARTS_F
          !DEC$ ATTRIBUTES C, REFERENCE, VARYING ::CDF_TT2000_TO_UTC_PARTS_F
          !DEC$ ALIAS CDF_TT2000_TO_UTC_PARTS_F, '_cdf_tt2000_to_utc_parts_f'
         END SUBROUTINE CDF_TT2000_TO_UTC_PARTS_F
       END INTERFACE

       INTERFACE
         SUBROUTINE CDF_TT2000_FROM_UTC_PARTS_F
          !DEC$ ATTRIBUTES C, REFERENCE, VARYING ::CDF_TT2000_FROM_UTC_PARTS_F
          !DEC$ ALIAS CDF_TT2000_FROM_UTC_PARTS_F, '_cdf_tt2000_from_utc_parts_f'
         END SUBROUTINE CDF_TT2000_FROM_UTC_PARTS_F
       END INTERFACE

       INTERFACE
         SUBROUTINE CDF_TT2000_TO_UTC_STRING_F
          !DEC$ ATTRIBUTES C, REFERENCE, VARYING ::CDF_TT2000_TO_UTC_STRING_F
          !DEC$ ALIAS CDF_TT2000_TO_UTC_STRING_F, '_cdf_tt2000_to_utc_string_f'
         END SUBROUTINE CDF_TT2000_TO_UTC_STRING_F
       END INTERFACE

       INTERFACE
         SUBROUTINE CDF_TT2000_FROM_UTC_STRING_F
          !DEC$ ATTRIBUTES C, REFERENCE, VARYING ::CDF_TT2000_FROM_UTC_STRING_F
          !DEC$ ALIAS CDF_TT2000_FROM_UTC_STRING_F, '_cdf_tt2000_from_utc_string_f'
         END SUBROUTINE CDF_TT2000_FROM_UTC_STRING_F
       END INTERFACE

       INTERFACE
         SUBROUTINE CDF_TT2000_TO_UTC_EPOCH_F
          !DEC$ ATTRIBUTES C, REFERENCE, VARYING ::CDF_TT2000_TO_UTC_EPOCH_F
          !DEC$ ALIAS CDF_TT2000_TO_UTC_EPOCH_F, '_cdf_tt2000_to_utc_epoch_f'
         END SUBROUTINE CDF_TT2000_TO_UTC_EPOCH_F
       END INTERFACE

       INTERFACE
         SUBROUTINE CDF_TT2000_FROM_UTC_EPOCH_F
          !DEC$ ATTRIBUTES C, REFERENCE, VARYING ::CDF_TT2000_FROM_UTC_EPOCH_F
          !DEC$ ALIAS CDF_TT2000_FROM_UTC_EPOCH_F, '_cdf_tt2000_from_utc_epoch_f'
         END SUBROUTINE CDF_TT2000_FROM_UTC_EPOCH_F
       END INTERFACE

       INTERFACE
         SUBROUTINE CDF_TT2000_TO_UTC_EPOCH16_F
          !DEC$ ATTRIBUTES C, REFERENCE, VARYING ::CDF_TT2000_TO_UTC_EPOCH16_F
          !DEC$ ALIAS CDF_TT2000_TO_UTC_EPOCH16_F, '_cdf_tt2000_to_utc_epoch16_f'
         END SUBROUTINE CDF_TT2000_TO_UTC_EPOCH16_F
       END INTERFACE

       INTERFACE
         SUBROUTINE CDF_TT2000_FROM_UTC_EPOCH16_F
          !DEC$ ATTRIBUTES C, REFERENCE, VARYING ::CDF_TT2000_FROM_UTC_EPOCH16_F
          !DEC$ ALIAS CDF_TT2000_FROM_UTC_EPOCH16_F, '_cdf_tt2000_from_utc_epoch16_f'
         END SUBROUTINE CDF_TT2000_FROM_UTC_EPOCH16_F
       END INTERFACE

       INTERFACE
         SUBROUTINE BREAKDOWN_TT2000
          !DEC$ ATTRIBUTES C, REFERENCE, VARYING ::BREAKDOWN_TT2000
          !DEC$ ALIAS BREAKDOWN_TT2000, '_breakdown_tt2000'
         END SUBROUTINE BREAKDOWN_TT2000
       END INTERFACE

       INTERFACE
         SUBROUTINE COMPUTE_TT2000
          !DEC$ ATTRIBUTES C, REFERENCE, VARYING ::COMPUTE_TT2000
          !DEC$ ALIAS COMPUTE_TT2000, '_compute_tt2000'
         END SUBROUTINE COMPUTE_TT2000
       END INTERFACE

       INTERFACE
         SUBROUTINE ENCODE_TT2000
          !DEC$ ATTRIBUTES C, REFERENCE, VARYING ::ENCODE_TT2000
          !DEC$ ALIAS ENCODE_TT2000, '_encode_tt2000'
         END SUBROUTINE ENCODE_TT2000
       END INTERFACE

       INTERFACE
         SUBROUTINE PARSE_TT2000
          !DEC$ ATTRIBUTES C, REFERENCE, VARYING ::PARSE_TT2000
          !DEC$ ALIAS PARSE_TT2000, '_parse_tt2000'
         END SUBROUTINE PARSE_TT2000
       END INTERFACE

       INTERFACE
         SUBROUTINE TT2000_TO_EPOCH
          !DEC$ ATTRIBUTES C, REFERENCE, VARYING ::TT2000_TO_EPOCH
          !DEC$ ALIAS TT2000_TO_EPOCH, '_tt2000_to_epoch'
         END SUBROUTINE TT2000_TO_EPOCH
       END INTERFACE

       INTERFACE
         SUBROUTINE TT2000_FROM_EPOCH
          !DEC$ ATTRIBUTES C, REFERENCE, VARYING ::TT2000_FROM_EPOCH
          !DEC$ ALIAS TT2000_FROM_EPOCH, '_tt2000_from_epoch'
         END SUBROUTINE TT2000_FROM_EPOCH
       END INTERFACE

       INTERFACE
         SUBROUTINE TT2000_TO_EPOCH16
          !DEC$ ATTRIBUTES C, REFERENCE, VARYING ::TT2000_TO_EPOCH16
          !DEC$ ALIAS TT2000_TO_EPOCH16, '_tt2000_to_epoch16'
         END SUBROUTINE TT2000_TO_EPOCH16
       END INTERFACE

       INTERFACE
         SUBROUTINE TT2000_FROM_EPOCH16
          !DEC$ ATTRIBUTES C, REFERENCE, VARYING ::TT2000_FROM_EPOCH16
          !DEC$ ALIAS TT2000_FROM_EPOCH16, '_tt2000_from_epoch16'
         END SUBROUTINE TT2000_FROM_EPOCH16
       END INTERFACE

       INTERFACE
         SUBROUTINE CDF_GETLEAPSECONDSTABLEENVVAR
          !DEC$ ATTRIBUTES C, REFERENCE, VARYING ::CDF_GETLEAPSECONDSTABLEENVVAR
          !DEC$ ALIAS CDF_GETLEAPSECONDSTABLEENVVAR, '_cdf_getleapsecondstableenvvar'
         END SUBROUTINE CDF_GETLEAPSECONDSTABLEENVVAR
       END INTERFACE

       INTERFACE
         SUBROUTINE CDF_GETLASTDATEINLEAPSECONDSTABLE
          !DEC$ ATTRIBUTES C, REFERENCE, VARYING ::CDF_GETLASTDATEINLEAPSECONDSTABLE
          !DEC$ ALIAS CDF_GETLASTDATEINLEAPSECONDSTABLE, '_cdf_getlastdateinleapsecondstable'    
         END SUBROUTINE CDF_GETLASTDATEINLEAPSECONDSTABLE
       END INTERFACE

       INTERFACE
         SUBROUTINE CDF_GETLEAPSECONDSTABLE
          !DEC$ ATTRIBUTES C, REFERENCE, VARYING ::CDF_GETLEAPSECONDSTABLE
          !DEC$ ALIAS CDF_GETLEAPSECONDSTABLE, '_cdf_getleapsecondstable'
         END SUBROUTINE CDF_GETLEAPSECONDSTABLE
       END INTERFACE

